function [image,Energies,Corr,Cut1,Cut2,FWHM,MaxMin,MaxDrift,Ind1,Ind2,Logbook] = BroadZLPAlign(handles)

global tracer

if isempty(tracer)
    tracer=1;
else
    image    = [];
    Energies = [];
    Corr     = [];
    FWHM     = [];
    MaxMin   = [];
    MaxDrift = [];
    Logbook  = [];
    Cut1     = [];
    Cut2     = [];
    Ind1     = [];
    Ind2     = [];
    clearvars -except image Energies Corr Cut1 Cut2 FWHM MaxMin MaxDrift Logbook Ind1 Ind2
    return
end
%% Load File
image      = load(fullfile(tempdir,'ShowOrg.mat')).image;

%% Get Handles
EnergyRes = get(handles.Slider, 'SliderStep');
FWHM      = get(handles.ShowFWHM,'UserData');
Energies  = get(handles.ZLPAlign,'UserData');
Logbook   = get(handles.Logbook,'UserData');

EnergyRes = EnergyRes(1);

%% Select ZLP region
% Allows the user to select a region in which all ZLP are to be found for
% faster alignment and to make the process less prone to cosmic rays.

Spec = reshape(image,[size(image,1)*size(image,2),size(image,3)]);
Spec = max(Spec,[],1);

fig  = figure('Name','Select region with ZLP - double click to confirm!');
plot(Energies,Spec,'Color','b');
hold on
plot(Energies,zeros(size(Energies)),'--','Color','k');                     % dotted zero line
hold off
legend('mean Spectrum');
ylabel( 'Counts' );
xlabel( 'Loss energy [eV]' );
ylim([-max(Spec)/2,max(Spec).*1.25]);
xlim([min(Energies,[],2),max(Energies,[],2)]);
maxEne   = max(Spec,[],2);
minEne   = min(Spec,[],2);
ZLP      = (minEne + maxEne) / 10;
index1   = (find(Spec >= ZLP, 1, 'first'));
index2   = (find(Spec >= ZLP, 1, 'last'));
Start    = Energies(index1)- mean(FWHM,'all')*2;
Width    = Energies(index2)- Start + mean(FWHM,'all')*2;
Start    = max(Start,Energies(1));
if Start+Width > Energies(end)
    Width = Energies(end)-Start;
end

try
    Select  = drawrectangle('Position',[Start,-max(Spec)/2,Width,max(Spec)/2+max(Spec).*1.25],'Color','b','StripeColor','w');
    l       = addlistener(Select,'ROIClicked',@(src,evt) DoubleClicker(src,evt));
    uiwait;
    pos     = Select.Position;
    Ind1    = pos(1);
    Ind2    = pos(1)+pos(3);
    clearvars pos
    Ind1    = find(Energies>=Ind1,1,'first');
    Ind2    = find(Energies<=Ind2,1,'last');
    delete(Select);
    close(fig);
    delete(l);
catch
    image    = [];
    Energies = [];
    Corr     = [];
    FWHM     = [];
    MaxMin   = [];
    MaxDrift = [];
    Logbook  = [];
    Cut1     = [];
    Cut2     = [];
    Ind1     = [];
    Ind2     = [];
    clearvars -except image Energies Corr Cut1 Cut2 FWHM MaxMin MaxDrift Logbook Ind1 Ind2
    clear global
    return
end


%% Calculate Peak position
[~,ZeroPos] = min(abs(Energies));                                          % Gives position of the zero.

%% ZLP Alignment
% Within the boundarys defined by the user, two FWHM positions are
% calculated. Within those two the absolute maximum is found.
% The procedure is choosen, because it is rather robust against consmic
% rays.
% The spectra are shifted circulary by their respective ZLP position in
% relation to the 0 position of the energy dispersion. The FWHM as a output
% parameter is kept, also the overall shift. Both can be seen in the
% FWHM and Drift map. However, with this curcular shift, shifts smaller
% than one dispersion step cannot be corrected. For better correction use
% FineZLPAlign script afterwards.

SizeX      = size(image,2);
SizeY      = size(image,1);
SizeZ      = size(image,3);

Kernel      = reshape(image(1,1,Ind1:Ind2),[1,size(image(:,:,Ind1:Ind2),3)]);
[~,Lag]     = CrossAlign(Kernel,Kernel);
[~,MaxPos]  = max(Kernel);
CorrShift   = ZeroPos-(MaxPos+Ind1-1);
Lag         = Lag - CorrShift;

image       = reshape(image,[size(image,1)*size(image,2),size(image,3)]);
img         = image(:,Ind1:Ind2);
[CF,~]      = CrossAlign(img,Kernel);
[~,MaxPos]  = max(CF,[],2);
Shift       = Lag(1,MaxPos)';

parfor i=1:size(image,1)
    image(i,:)    = circshift(image(i,:),-Shift(i),2);
end

I          = sum(image,1);
[~,MaxPos] = max(I);
clearvars I 

ShiftEnd   = ZeroPos - MaxPos;
image      = circshift(image,ShiftEnd,2);
Shift      = Shift - ShiftEnd;
image      = reshape(image,[SizeY,SizeX,SizeZ]);
Shift      = reshape(Shift,[SizeY,SizeX]);
CorrNew    = Shift.*EnergyRes;
 
FWHM(isnan(FWHM)) = mean(FWHM(~isnan(FWHM)),'all');
%% Cut ends
% Due to the alignment, there are points at the boundarys of the spectra, that do not belong
% to their current energy position, as it was shifted circularry over the
% edge. E.g: a point belonging to -3eV is now circulary shifted to
% +20eV. To cut those points out, the maximum shift has to be found. Image
% and Dispersion then are corrected correspondingly.

Cut1     = floor(min(CorrNew,[],'all')./EnergyRes);
Cut2     =  ceil(max(CorrNew,[],'all')./EnergyRes);
EOld     = Energies;
if Cut2>0
    image    =  image(:,:,1:end-Cut2);
    Energies = Energies(:,1:end-Cut2);
else
    Cut2     = 0;
end
if Cut1<0
    image    =  image(:,:,1-Cut1:end);
    Energies = Energies(:,1-Cut1:end);
    Cut1     = -Cut1;
else
    Cut1     = 0;
end

Corr         = CorrNew;
MaxMin       = [Energies(end),Energies(1)];
MaxDrift     = max(abs(CorrNew),[],'all');
[row,col]    = find(abs(CorrNew)==MaxDrift);
MaxDrift     = CorrNew(row(1),col(1));


%% Create Logbook entry
Logbook{end+1} = ['BroadAlign:  StartVal: ' , num2str(EOld(Ind1)) ,'eV  |  EndVal: ' , num2str(EOld(Ind2)) , 'eV  |  maxDrift: ', num2str(MaxDrift), 'eV'];

clearvars -except image Energies Corr Cut1 Cut2 FWHM MaxMin MaxDrift Logbook Ind1 Ind2
end